//
//  GLiveFastConfig.h
//  GLiveSDK
//
//  Created by net263 on 2021/8/11.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

/**
 *SDK功能类型
 */
typedef NS_ENUM(NSInteger, GLiveFastSDKType)
{
    //观看端
    GLiveFastSDKTypeWatch,
    //发布端
    GLiveFastSDKTypePublish,
    //点播
    GLiveFastSDKTypeVod,

};

/**
 *SDK发布端类型
 */
typedef NS_ENUM(NSInteger, GLiveFastSDKPublishType)
{
    //分屏
    GLiveFastSDKPublishTypeNormal,
    //竖屏
    GLiveFastSDKPublishTypePortrait,
    //横屏
    GLiveFastSDKPublishTypeLandScape,

};

/**
 *SDK发布端视频质量
 */
typedef NS_ENUM(NSInteger, GLiveFastSDKPublishQualityType)
{
    //标清
    GLiveFastSDKPublishQualityTypeNormal,
    //高清
    GLiveFastSDKPublishQualityTypeHigh,
    //超清
    GLiveFastSDKPublishQualityTypeLive,

};

/**
 *SDK发布端视频发布比例
 */
typedef NS_ENUM(NSInteger, GLiveFastSDKPublishCropMode)
{
    //4:3
    GLiveFastSDKPublishCropMode4_3,
    //16:9
    GLiveFastSDKPublishCropMode16_9,

};
@interface GLiveFastConfig : NSObject
@property(nonatomic, assign)GLiveFastSDKType sdkType;//sdk支持的功能类型
@property(nonatomic, assign)GLiveFastSDKPublishType sdkPublishType;//发布端类型
@property(nonatomic, assign)GLiveFastSDKPublishQualityType sdkPublishQualityType;//发布端视频分辨率
@property(nonatomic, assign)GLiveFastSDKPublishCropMode sdkPublishCropMode;//发布端视频发布比例


@property(nonatomic, assign)BOOL httpAPIEnabled;
@property(nonatomic, assign)BOOL hardwareAccelerateVideoDecodeSupport;
@property(nonatomic, assign)BOOL hardwareAccelerateASDecodeSupport;
@property(nonatomic, assign)BOOL hardwareAccelerateEncodeSupport;

@property(nonatomic, copy)NSString *vodShareUrl;

@end

NS_ASSUME_NONNULL_END
